<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $impostazioniLingue= $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    $tipo              = isset($_GET["tipo"]) ? filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_STRING) : "";
    $linguaSelezionata = isset($_GET["lingua"]) ? filter_input(INPUT_GET,"lingua",FILTER_SANITIZE_STRING) : $impostazioniLingue["linguaPrincipale"];
    
    $parametriRicerca  = $cerca!="" ? array("tipo"=>$tipo,"titolo"=>$cerca,"linguaContenuto"=>$linguaSelezionata) : array("tipo"=>$tipo,"linguaContenuto"=>$linguaSelezionata);
    $parametri = array("tabella"=>"geecB_contenuti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneContenuti.php");
    $ricerca->setParametriDaEscludere(array("alias"=>""));
    if($tipo=="pagina") {
        $fraseEelenco = "Elenco pagine";
        $linkNuvoContenuto = "creaContenuto.php?tipo=pagina";
    }
    else if($tipo=="articolo") {
        $fraseEelenco = "Elenco articoli";
        $linkNuvoContenuto = "../controller/controllerContenuti.php?operazione=creaArticolo";
    }
    else { // tipo = galleria
        $fraseEelenco = "Elenco gallerie";
        $linkNuvoContenuto = "creaContenuto.php?tipo=galleria";
    }
    
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom CMS - gestione contenuti</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
    <?php  
        include "include/barraSuperiore.php";

        include "include/header.php";

        include "include/barraMenu.php";
    ?>
    </header>
    
    <?php 

        if(isset($_GET["status"])) {
            if($_GET["status"]==1) {
                    echo"<p class=\"alert alert-success\">Utente creato</p>";
            }
            else if($_GET["status"]==2) {
                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
            }
            else if($_GET["status"]==4) {
                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
            }
            else if($_GET["status"]==400) {
                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
            }
            else { //status = 5
                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
            }
        }
    ?>
     <!-- Modal box conferma cancellazione elemento-->
    <div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title" id="myModalLabel3">Eliminare l'utente: </h4>
          </div>
            <form class="form-horizontal" role="form" name="formCancellazione" action="utenti/cancellaUtente.php" method="post">
	       	<input type="text" class="hidden" id="utenteDaEliminare" name="idUtente" >
        	  </form>
          
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
            <button type="button" class="btn btn-primary" onclick="{document.formCancellazione.submit();}" >Elimina</button>
          </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"><?= $fraseEelenco ?></span>
                            <a href="<?= $linkNuvoContenuto ?>" class="btn btn-sm btn-primary" >
                                Crea <?=(($tipo=="articolo") ? "nuovo" : "nuova")?><i class="fas fa-plus ml-2"></i>
                            </a>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-sm-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca,array("lingua"=>$linguaSelezionata,"tipo"=>$tipo));
                                    ?>
                                    
                                    <form class="form-inline" name="formRicerca" action="gestioneContenuti.php">
                                        <div class="input-group">
                                            <input type="text" class="d-none" name="elementiPerPagina" value="<?= $elementiPerPagina ?>">
                                            <input type="text" class="d-none" name="tipo" value="<?= $tipo ?>">
                                            <input type="text" class="form-control" id="cerca" aria-describedby="cerca" name="cerca" placeholder="Cerca..." value="<?= $cerca ?>">
                                            <select name="lingua" class="custom-select">
                                                <option value="" <?= (($linguaSelezionata=="") ? "selected" : ""); ?>>Tutte le lingue</option>
                                                <?php 
                                                    foreach($lingue as $lingua) {
                                                ?>
                                                        <option value="<?= $lingua ?>" <?=(($linguaSelezionata==$lingua) ? "selected" : ""); ?>><?= $lingua ?></option>
                                                <?php
                                                    }
                                                ?>
                                            </select>
                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php

                                        if(isset($_GET["idTag"])) {
                                            $idTag = filter_input(INPUT_GET,"idTag",FILTER_SANITIZE_NUMBER_INT);
                                            $query = "SELECT c.* FROM geecB_contenuti AS c JOIN geecB_associazioniTagArticoli AS at ON c.id=at.idArticolo WHERE idTag=$idTag LIMIT $elementiPerPagina";
                                            $ris   = $geecomDb->eseguiQueryLettura($query);
                                        }
                                        else if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }
                                        
                                        if($tipo=="articolo") {
                                            $colonne = array("ID","Lingua","Titolo","Categorie","Autore","Visite","Creato il","Stato","SEO","");
                                        }
                                        else {
                                            $colonne = array("ID","Lingua","Titolo","Autore","Visite","Creato il","Stato","SEO","");
                                        }
                                        
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($contenuto = $ris->fetch_assoc()) {
                                            $titoloEscape        = filter_var($contenuto["titolo"],FILTER_SANITIZE_ADD_SLASHES);
                                            $dataCreazione       = date("d/m/Y",strtotime($contenuto["dataCreazione"]));
                                            if($contenuto["punteggioSeo"]=="scadente") {                                            
                                                $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                                            }
                                            else if($contenuto["punteggioSeo"]=="discreta") {
                                                $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                                            }
                                            else if($contenuto["punteggioSeo"]=="buona") {
                                                $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                                            }
                                            else {
                                                $stringaPunteggioSEO = "";
                                            }
                                            
                                            if($contenuto["stato"]=="pubblicato") {
                                                $stringaStato = "<i class=\"fas fa-circle text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"pubblicato\"></i>";
                                            }
                                            else {
                                                $stringaStato = "<i class=\"fas fa-circle text-black-50\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"bozza\"></i>";
                                            }
                                            
                                            $urlPagina = GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                                            $azioni = array("visualizza"=>$urlPagina,"modifica"=>"creaContenuto.php?id={$contenuto["id"]}","duplica"=>"../controller/controllerContenuti.php?operazione=duplica&id={$contenuto["id"]}","elimina"=>"eliminaPagina({$contenuto["id"]},'{$titoloEscape}')");
                                            
                                            if($tipo=="articolo") {
                                                if($contenuto["categoria"]!=0) {
                                                    $categoriaArticolo = $geecomDb->leggiSingolaRiga("geec_categorie", $contenuto["categoria"]);
                                                    $nomeCategoria = "{$categoriaArticolo["nome"]}";
                                                }
                                                else {
                                                    $nomeCategoria = "nessuna";
                                                }
                                                
                                                $tabella->aggiungiNuovaRiga(array($contenuto["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($contenuto["linguaContenuto"])."\">","<b><a href=\"creaContenuto.php?id={$contenuto["id"]}\">{$contenuto["titolo"]}</a></b>
                                                    <span class=\"d-block text-muted\">$urlPagina</span>",$nomeCategoria,$contenuto["autore"],$contenuto["numeroVisite"],$dataCreazione,$stringaStato,$stringaPunteggioSEO),$azioni);
                                            }
                                            else {
                                                $tabella->aggiungiNuovaRiga(array($contenuto["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($contenuto["linguaContenuto"])."\">","<b><a href=\"creaContenuto.php?id={$contenuto["id"]}\">{$contenuto["titolo"]}</a></b>
                                                    <span class=\"d-block text-muted\">$urlPagina</span>",$contenuto["autore"],$contenuto["numeroVisite"],$dataCreazione,$stringaStato,$stringaPunteggioSEO),$azioni);
                                            }
                                        }

                                        $tabella->stampa("pagina",0);
                                            
                                        $ricerca->stampaPaginazione(true,"gestioneContenuti.php?tipo=$tipo&lingua=$linguaSelezionata");
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/operazioneCompletata.php";
                
        include "include/jsBaseAreaAmministrativa.php";
    ?>
    
    <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare il contenuto?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomePaginaDaEliminare"></em></span>
                            <div id="tipoElementoDaEliminare"></div>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="paginaDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazionePagina()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">

        function modificaAmministratore(idUtente,nome,cognome,email,ruolo) {
            $('#myModalLabel2').text("Modifica i dati dell'utente "+nome);
            document.getElementById("idUtente").value = idUtente;
            document.getElementById("campoTesto2").value = nome;
            document.getElementById("campoTesto3").value = cognome;
            document.getElementById("inputEmail2").value = email;
            document.getElementById("ruoloAmministratore").value = ruolo;
            $('#myModal2').modal('show');
        }

        function eliminaAmministratore(idUtente,nome) {
            $('#myModalLabel3').text("Eliminare l'utente "+nome+"?");
            document.getElementById("utenteDaEliminare").value = idUtente;
            $('#myModal3').modal('show');
        }
        
        function funzione() {
            alert("cambiato");
        }
        
        function eliminaPagina(id,titoloPagina) {
            $('#paginaDaEliminare').val(id);
            $('#nomePaginaDaEliminare').text(titoloPagina);
            $('#modalEliminaElemento').modal('show');
        }

        function eseguiEliminazionePagina() {
            var id = $('#paginaDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../controller/controllerContenuti.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("pagina"+id).className = "d-none";
                        $('#modalEliminaElemento').modal('hide');
                    }
                    else {
                        $('#modalEliminaElemento').modal('hide');
                        alert(esito);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>